/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.client.model;

import com.google.common.collect.ImmutableList;
import com.minecraftabnormals.neapolitan.common.entity.ChimpanzeeEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;

public class ChimpanzeeModel<T extends ChimpanzeeEntity>
extends AgeableModel<T>
implements IHasArm,
IHasHead {
    private final ModelRenderer body;
    private final ModelRenderer head;
    private final ModelRenderer rightEar;
    private final ModelRenderer leftEar;
    private final ModelRenderer leftArm;
    private final ModelRenderer rightArm;
    private final ModelRenderer leftLeg;
    private final ModelRenderer rightLeg;

    public ChimpanzeeModel() {
        super(false, 10.0f, 0.0f, 2.0f, 2.0f, 24.0f);
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, 9.0f, 2.0f);
        this.body.func_78784_a(37, 0).func_228303_a_(-5.0f, -4.0f, -3.0f, 10.0f, 8.0f, 3.0f, 0.0f, false);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, 5.0f, 0.5f);
        this.head.func_78784_a(1, 1).func_228303_a_(-4.0f, -8.0f, -3.0f, 8.0f, 8.0f, 6.0f, 0.0f, false);
        this.head.func_78784_a(30, 11).func_228303_a_(-2.0f, -5.0f, -4.0f, 4.0f, 5.0f, 1.0f, 0.0f, false);
        this.rightEar = new ModelRenderer((Model)this);
        this.rightEar.func_78793_a(-4.0f, -3.0f, 0.0f);
        this.head.func_78792_a(this.rightEar);
        this.rightEar.func_78784_a(25, 1).func_228303_a_(-2.0f, -4.0f, -1.0f, 2.0f, 3.0f, 1.0f, 0.0f, false);
        this.leftEar = new ModelRenderer((Model)this);
        this.leftEar.func_78793_a(4.0f, -5.0f, 0.0f);
        this.head.func_78792_a(this.leftEar);
        this.leftEar.func_78784_a(25, 1).func_228303_a_(0.0f, -2.0f, -1.0f, 2.0f, 3.0f, 1.0f, 0.0f, true);
        this.leftArm = new ModelRenderer((Model)this);
        this.leftArm.func_78793_a(5.0f, 6.5f, 0.5f);
        this.leftArm.func_78784_a(14, 17).func_228303_a_(0.0f, -1.5f, -1.5f, 3.0f, 11.0f, 3.0f, 0.0f, true);
        this.rightArm = new ModelRenderer((Model)this);
        this.rightArm.func_78793_a(-5.0f, 6.5f, 0.5f);
        this.rightArm.func_78784_a(1, 17).func_228303_a_(-3.0f, -1.5f, -1.5f, 3.0f, 11.0f, 3.0f, 0.0f, false);
        this.leftLeg = new ModelRenderer((Model)this);
        this.leftLeg.func_78793_a(2.5f, 13.0f, 0.5f);
        this.leftLeg.func_78784_a(40, 17).func_228303_a_(-1.5f, 0.0f, -1.5f, 3.0f, 11.0f, 3.0f, 0.0f, true);
        this.rightLeg = new ModelRenderer((Model)this);
        this.rightLeg.func_78793_a(-2.5f, 13.0f, 0.5f);
        this.rightLeg.func_78784_a(27, 17).func_228303_a_(-1.5f, 0.0f, -1.5f, 3.0f, 11.0f, 3.0f, 0.0f, false);
    }

    public void setRotationAngles(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        if (this.field_217113_d) {
            this.rightArm.field_78795_f += -0.62831855f;
            this.leftArm.field_78795_f += -0.62831855f;
            this.rightLeg.field_78795_f = -1.4137167f;
            this.rightLeg.field_78796_g = 0.31415927f;
            this.rightLeg.field_78808_h = 0.07853982f;
            this.leftLeg.field_78795_f = -1.4137167f;
            this.leftLeg.field_78796_g = -0.31415927f;
            this.leftLeg.field_78808_h = -0.07853982f;
        }
    }

    public void setLivingAnimations(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        int i = ((ChimpanzeeEntity)((Object)entityIn)).getAttackTimer();
        if (i > 0) {
            this.rightArm.field_78795_f = -2.0f + 1.5f * MathHelper.func_233021_e_((float)((float)i - partialTick), (float)10.0f);
            this.leftArm.field_78795_f = -2.0f + 1.5f * MathHelper.func_233021_e_((float)((float)i - partialTick), (float)10.0f);
        } else {
            float f = !this.field_217113_d ? ((ChimpanzeeEntity)((Object)entityIn)).getClimbingAnimationScale(partialTick) : 0.0f;
            float climbanim = -f * (float)Math.PI / 2.0f;
            this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / 1.0f + climbanim * 1.4f;
            this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / 1.0f + climbanim * 1.4f;
            this.rightArm.field_78808_h = 0.0f;
            this.leftArm.field_78808_h = 0.0f;
            this.rightArm.field_78796_g = -climbanim * 0.4f;
            this.leftArm.field_78796_g = climbanim * 0.4f;
            this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / 1.0f + climbanim * 0.5f;
            this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / 1.0f + climbanim * 0.5f;
            this.rightLeg.field_78796_g = 0.0f;
            this.leftLeg.field_78796_g = 0.0f;
            this.rightLeg.field_78808_h = 0.0f;
            this.leftLeg.field_78808_h = 0.0f;
            if (this.field_217113_d) {
                this.rightArm.field_78795_f += -0.62831855f;
                this.leftArm.field_78795_f += -0.62831855f;
                this.rightLeg.field_78795_f = -1.4137167f;
                this.rightLeg.field_78796_g = 0.31415927f;
                this.rightLeg.field_78808_h = 0.07853982f;
                this.leftLeg.field_78795_f = -1.4137167f;
                this.leftLeg.field_78796_g = -0.31415927f;
                this.leftLeg.field_78808_h = -0.07853982f;
            }
        }
    }

    protected HandSide getMainHand(T entityIn) {
        HandSide handside = entityIn.func_184591_cq();
        return ((ChimpanzeeEntity)((Object)entityIn)).field_184622_au == Hand.MAIN_HAND ? handside : handside.func_188468_a();
    }

    protected ModelRenderer getArmForSide(HandSide side) {
        return side == HandSide.LEFT ? this.leftArm : this.rightArm;
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg);
    }

    public ModelRenderer func_205072_a() {
        return this.head;
    }

    public void func_225599_a_(HandSide sideIn, MatrixStack matrixStackIn) {
        this.getArmForSide(sideIn).func_228307_a_(matrixStackIn);
    }
}

